(function($) {
  $.fn.easyTabs = function(options) {

    var opts = $.extend({}, $.fn.easyTabs.defaults, options);

    return this.each(function() {
      var container = $(this);
      var tabs = $(container.find("ul > li"));
      var panels = $();
      tabs.each(function(){
         panels = panels.add(container.find("div[id=" + $(this).children("a").attr("href").substr(1) + "]").hide());
      });
      var defaultTab = $(container.find("ul > " + opts.defaultTab));
      $(panels.filter("#" + defaultTab.children("a").attr("href").substr(1))).show().addClass(opts.panelActiveClass);
      
      defaultTab.addClass(opts.tabActiveClass).children().addClass(opts.tabActiveClass);
      
      tabs.children("a").click(function() {
            var clicked = $($(this));
            if(clicked.hasClass(opts.tabActiveClass)){ return false; }
            if(opts.animate){
               panels.filter("." + opts.panelActiveClass).removeClass(opts.panelActiveClass).fadeOut(opts.animationSpeed, function(){
                  panels.filter("#" + $(clicked).attr("href").substr(1)).fadeIn(opts.animationSpeed, function(){ $(this).addClass(opts.panelActiveClass); });
               });
            }else{
               panels.filter("." + opts.panelActiveClass).removeClass(opts.panelActiveClass).hide();
               panels.filter("#" + $(clicked).attr("href").substr(1)).show().addClass(opts.panelActiveClass);
            }
            tabs.removeClass(opts.tabActiveClass).children().removeClass(opts.tabActiveClass);
            clicked.parent().addClass(opts.tabActiveClass).children().addClass(opts.tabActiveClass);
            return false;
          });
    });

  }

  $.fn.easyTabs.defaults = {animate: true, panelActiveClass: "active", tabActiveClass: "active", defaultTab: "li:first-child", animationSpeed: "normal"}
})(jQuery);